-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema factura
--

-- CREATE DATABASE IF NOT EXISTS factura;
-- USE factura;

--
-- Definition of table `cliente`
--

DROP TABLE IF EXISTS `cliente`;
CREATE TABLE `cliente` (
  `idcliente` int(11) NOT NULL AUTO_INCREMENT,
  `Nif` varchar(12) NOT NULL,
  `NombreRazonSocial` varchar(120) NOT NULL,
  `Domicilio` varchar(100) NOT NULL,
  `RestoDomicilio` varchar(100) NOT NULL,
  `Email` varchar(100) NOT NULL,
  PRIMARY KEY (`idcliente`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `cliente`
--

/*!40000 ALTER TABLE `cliente` DISABLE KEYS */;
INSERT INTO `cliente` (`idcliente`,`Nif`,`NombreRazonSocial`,`Domicilio`,`RestoDomicilio`,`Email`) VALUES 
 (1,'00000003M','Cliente 1','C/ del Pino Verde, 1 áéíúó ñ','2045 Madrid','info@fhumanes.com'),
 (2,'00000002E','Cliente 2','Avda. de Gracia, 23','08001 Barcelona','info@fhumanes.com');
/*!40000 ALTER TABLE `cliente` ENABLE KEYS */;


--
-- Definition of table `factura`
--

DROP TABLE IF EXISTS `factura`;
CREATE TABLE `factura` (
  `idfactura` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_idcliente` int(11) NOT NULL,
  `Nif` varchar(12) NOT NULL,
  `NombreRazonSocial` varchar(120) NOT NULL,
  `Domicilio` varchar(100) NOT NULL,
  `RestoDomicilio` varchar(100) NOT NULL,
  `FechaFactura` date NOT NULL,
  `TotalFactura` decimal(12,2) DEFAULT '0.00',
  `Email` varchar(100) NOT NULL,
  PRIMARY KEY (`idfactura`),
  KEY `fk_factura_cliente_idx` (`cliente_idcliente`),
  CONSTRAINT `fk_factura_cliente` FOREIGN KEY (`cliente_idcliente`) REFERENCES `cliente` (`idcliente`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `factura`
--

/*!40000 ALTER TABLE `factura` DISABLE KEYS */;
INSERT INTO `factura` (`idfactura`,`cliente_idcliente`,`Nif`,`NombreRazonSocial`,`Domicilio`,`RestoDomicilio`,`FechaFactura`,`TotalFactura`,`Email`) VALUES 
 (1,1,'00000003M','Cliente 1','C/ del Pino Verde, 1 áéíúó ñ','2045 Madrid','2021-03-31','86.20','info@fhumanes.com'),
 (2,2,'00000002E','Cliente 2','Avda. de Gracia, 23','Cliente 2','2021-05-06','52827.97','info@fhumanes.com'),
 (6,1,'00000003M','Cliente 1','C/ del Pino Verde, 1 áéíúó ñ','2045 Madrid','2021-07-09','61.43','info@fhumanes.com'),
 (8,2,'00000002E','Cliente 2','Avda. de Gracia, 23','08001 Barcelona','2021-09-24','35.21','info@fhumanes.com'),
 (9,1,'00000003M','Cliente 1','C/ del Pino Verde, 1 áéíúó ñ','2045 Madrid','2021-10-08','52.10','info@fhumanes.com');
/*!40000 ALTER TABLE `factura` ENABLE KEYS */;


--
-- Definition of table `invoice_settings`
--

DROP TABLE IF EXISTS `invoice_settings`;
CREATE TABLE `invoice_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `invoice_settings`
--

/*!40000 ALTER TABLE `invoice_settings` DISABLE KEYS */;
INSERT INTO `invoice_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":362.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":121.4,\"grid_headcell_field2\":94.4}}','producto'),
 (2,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":484,\"thWidths\":{\"grid_headcell_field\":10,\"grid_headcell_field1\":38,\"grid_headcell_field2\":50,\"grid_headcell_field3\":62,\"grid_headcell_field4\":30,\"grid_headcell_field5\":47,\"grid_headcell_field6\":190}}','linea_factura'),
 (3,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":639.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":78.4,\"grid_headcell_field2\":84.4,\"grid_headcell_field3\":184.4,\"grid_headcell_field4\":125.4}}','cliente'),
 (4,2,NULL,NULL,'5dieboouy0s3054leclssq0z','{\"gridWidth\":688.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":84.4,\"grid_headcell_field2\":66.4,\"grid_headcell_field3\":59.4,\"grid_headcell_field4\":199.4,\"grid_headcell_field6\":67.4,\"grid_headcell_field7\":68.4}}','factura'),
 (5,2,NULL,NULL,'f1piy038w1nf3hhoh03a7nib','{\"gridWidth\":709.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":84.4,\"grid_headcell_field2\":66.4,\"grid_headcell_field3\":59.4,\"grid_headcell_field4\":220.4,\"grid_headcell_field6\":67.4,\"grid_headcell_field7\":68.4}}','factura'),
 (6,2,NULL,NULL,'6mh2spov5uk76mowqj8apd8n','{\"gridWidth\":326.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":135.4,\"grid_headcell_field2\":87.4}}','producto'),
 (7,2,NULL,NULL,'9mro60yo7k08rjybkgdo5taa','{\"gridWidth\":985.4,\"thWidths\":{\"grid_headcell_icons\":27.4,\"grid_headcell_checkbox\":13.399999999999999,\"grid_headcell_details\":58.4,\"grid_headcell_field\":43.4,\"grid_headcell_field1\":141.4,\"grid_headcell_field2\":149.4,\"grid_headcell_field3\":149.4,\"grid_headcell_field4\":149.4,\"grid_headcell_field5\":149.4}}','cliente'),
 (8,2,NULL,NULL,'lruelcso14t5hxxt6bri39ga','{\"gridWidth\":787.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":56.4,\"grid_headcell_field1\":131.4,\"grid_headcell_field2\":84.4,\"grid_headcell_field3\":59.4,\"grid_headcell_field4\":170.4,\"grid_headcell_field6\":79.4,\"grid_headcell_field7\":72.4}}','factura'),
 (9,2,NULL,NULL,'x573w6d7et3ugsel7mwnl2fm','{\"gridWidth\":421.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":19.4,\"grid_headcell_field\":105.4,\"grid_headcell_field1\":104.4,\"grid_headcell_field2\":118.4}}','producto'),
 (10,2,NULL,NULL,'x573w6d7et3ugsel7mwnl2fm','{\"gridWidth\":691.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":84.4,\"grid_headcell_field2\":66.4,\"grid_headcell_field3\":59.4,\"grid_headcell_field4\":202.4,\"grid_headcell_field6\":67.4,\"grid_headcell_field7\":68.4}}','factura'),
 (11,2,NULL,NULL,'23nnlmxpyk5wphhrss7hcqsh','{\"gridWidth\":744.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":84.4,\"grid_headcell_field2\":66.4,\"grid_headcell_field3\":97.4,\"grid_headcell_field4\":190.4,\"grid_headcell_field6\":72.4,\"grid_headcell_field7\":75.4}}','factura'),
 (12,2,NULL,NULL,'1l4closjsdbs360glww626rp','{\"gridWidth\":726.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":84.4,\"grid_headcell_field2\":66.4,\"grid_headcell_field3\":59.4,\"grid_headcell_field4\":221.4,\"grid_headcell_field6\":67.4,\"grid_headcell_field7\":68.4}}','factura'),
 (13,2,NULL,NULL,'1l4closjsdbs360glww626rp','{\"gridWidth\":397.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":181.4,\"grid_headcell_field2\":28.4,\"grid_headcell_field3\":64.4}}','producto'),
 (14,2,NULL,NULL,'1l4closjsdbs360glww626rp','{\"gridWidth\":861.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":59.4,\"grid_headcell_field2\":84.4,\"grid_headcell_field3\":221.4,\"grid_headcell_field4\":114.4,\"grid_headcell_field5\":189.4}}','cliente'),
 (15,2,NULL,NULL,'b35r3zyec3d54ndqaa18wwvl','{\"gridWidth\":509.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":208.4,\"grid_headcell_field2\":189.4}}','producto'),
 (16,2,NULL,NULL,'0q8t5l4706nljzlhww2q8kt7','{\"gridWidth\":715.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":9.399999999999999,\"grid_headcell_field1\":84.4,\"grid_headcell_field2\":66.4,\"grid_headcell_field3\":59.4,\"grid_headcell_field4\":200.4,\"grid_headcell_field6\":67.4,\"grid_headcell_field7\":79.4}}','factura');
/*!40000 ALTER TABLE `invoice_settings` ENABLE KEYS */;


--
-- Definition of table `linea_factura`
--

DROP TABLE IF EXISTS `linea_factura`;
CREATE TABLE `linea_factura` (
  `idlinea_factura` int(11) NOT NULL AUTO_INCREMENT,
  `factura_idfactura` int(11) NOT NULL,
  `producto_idproducto` int(11) NOT NULL,
  `Nombre` varchar(50) NOT NULL,
  `Precio` decimal(12,2) NOT NULL,
  `Cantidad` int(11) NOT NULL,
  `Valor` decimal(12,2) NOT NULL,
  PRIMARY KEY (`idlinea_factura`),
  KEY `fk_linea_factura_factura1_idx` (`factura_idfactura`),
  KEY `fk_linea_factura_producto1_idx` (`producto_idproducto`),
  CONSTRAINT `fk_linea_factura_factura1` FOREIGN KEY (`factura_idfactura`) REFERENCES `factura` (`idfactura`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_linea_factura_producto1` FOREIGN KEY (`producto_idproducto`) REFERENCES `producto` (`idproducto`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `linea_factura`
--

/*!40000 ALTER TABLE `linea_factura` DISABLE KEYS */;
INSERT INTO `linea_factura` (`idlinea_factura`,`factura_idfactura`,`producto_idproducto`,`Nombre`,`Precio`,`Cantidad`,`Valor`) VALUES 
 (1,1,3,'Artículo 3\r\nSegunda línea','3.00',20,'60.00'),
 (2,1,2,'Artículo 2','1.25',10,'12.50'),
 (3,1,5,'Artículo 5','1.00',5,'5.00'),
 (4,1,4,'Artículo 4','0.58',15,'8.70'),
 (6,2,3,'Artículo 3','3.00',10,'30.00'),
 (7,2,2,'Artículo 2','1.25',10,'12.50'),
 (13,2,1,'Artículo 1','5.21',10,'52.10'),
 (16,6,1,'Artículo 1','5.21',1,'8.75'),
 (17,6,1,'Artículo 1','5.21',10,'52.10'),
 (18,2,4,'Artículo 4','0.58',10,'5.80'),
 (19,8,1,'Artículo 1','5.21',1,'5.21'),
 (20,8,3,'Artículo 3','3.00',10,'30.00'),
 (21,9,1,'Artículo 1','5.21',10,'52.10'),
 (22,6,4,'Artículo 4','0.58',1,'0.58'),
 (23,2,1,'Artículo 1','5.21',10000,'52100.00'),
 (24,2,2,'Artículo 2','1.25',10,'12.50'),
 (25,2,3,'Artículo 3','3.00',15,'45.00'),
 (26,2,4,'Artículo 4','0.58',5,'2.90'),
 (27,2,5,'Artículo 5','1.00',10,'10.00'),
 (28,2,1,'Artículo 1','5.21',15,'78.15'),
 (29,2,2,'Artículo 2','1.25',10,'12.50'),
 (30,2,3,'Artículo 3','3.00',5,'15.00'),
 (31,2,5,'Artículo 5','1.00',1,'1.00'),
 (32,2,1,'Artículo 1','5.21',10,'52.10'),
 (33,2,2,'Artículo 2','1.25',10,'12.50'),
 (34,2,4,'Artículo 4','0.58',1,'0.58'),
 (35,2,3,'Artículo 3','3.00',15,'45.00'),
 (36,2,1,'Artículo 1','5.21',1,'5.21'),
 (37,2,2,'Artículo 2','1.25',1,'1.25'),
 (38,2,4,'Artículo 4','0.58',1,'0.58'),
 (39,2,3,'Artículo 3','3.00',1,'3.00'),
 (40,2,5,'Artículo 5','1.00',1,'1.00'),
 (41,2,1,'Artículo 1','5.21',10,'52.10'),
 (42,2,2,'Artículo 2','1.25',10,'12.50'),
 (43,2,2,'Artículo 2','1.25',10,'12.50'),
 (44,2,3,'Artículo 3','3.00',10,'30.00'),
 (45,2,4,'Artículo 4','0.58',10,'5.80'),
 (46,2,1,'Artículo 1','5.21',14,'72.94'),
 (47,2,2,'Artículo 2','1.25',15,'18.75'),
 (48,2,4,'Artículo 4','0.58',16,'9.28'),
 (49,2,5,'Artículo 5','1.00',20,'20.00'),
 (50,2,1,'Artículo 1','5.21',10,'52.10'),
 (51,2,2,'Artículo 2','1.25',15,'18.75'),
 (52,2,3,'Artículo 3','3.00',8,'24.00'),
 (53,2,4,'Artículo 4','0.58',1,'0.58');
/*!40000 ALTER TABLE `linea_factura` ENABLE KEYS */;


--
-- Definition of table `product`
--

DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
  `idproducto` int(10) NOT NULL DEFAULT '0',
  `Nombre` varchar(50) DEFAULT NULL,
  `Precio` decimal(12,2) DEFAULT NULL,
  `foto` blob,
  PRIMARY KEY (`idproducto`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `product`
--

/*!40000 ALTER TABLE `product` DISABLE KEYS */;
INSERT INTO `product` (`idproducto`,`Nombre`,`Precio`,`foto`) VALUES 
 (1,'Frutillas','10.00',0xFFD8FFE000104A46494600010101006000600000FFDB0043000201010201010202020202020202030503030303030604040305070607070706070708090B0908080A0807070A0D0A0A0B0C0C0C0C07090E0F0D0C0E0B0C0C0CFFDB004301020202030303060303060C0807080C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0CFFC0001108006E00A503012200021101031101FFC4001F0000010501010101010100000000000000000102030405060708090A0BFFC400B5100002010303020403050504040000017D01020300041105122131410613516107227114328191A1082342B1C11552D1F02433627282090A161718191A25262728292A3435363738393A434445464748494A535455565758595A636465666768696A737475767778797A838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE1E2E3E4E5E6E7E8E9EAF1F2F3F4F5F6F7F8F9FAFFC4001F0100030101010101010101010000000000000102030405060708090A0BFFC400B51100020102040403040705040400010277000102031104052131061241510761711322328108144291A1B1C109233352F0156272D10A162434E125F11718191A262728292A35363738393A434445464748494A535455565758595A636465666768696A737475767778797A82838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE2E3E4E5E6E7E8E9EAF2F3F4F5F6F7F8F9FAFFDA000C03010002110311003F00F8A7E30E8CFA6DFBFCBFE79AF29BD6DE73B7F3AFA1FE39D8C735C48CFB768EE7F1AF0BD5F4E5F31963F5ED5F0980A9789F272C2C61A1534B9FC823F9575DE1CF88B269D2290F8F5F7AE2EE6D1ED93A95E3AD635FEADF665FEE9F4CF4AF47D8FB4D19C189A49C743E97F0BFC76D8AAAD2B0E31CB74FC2BA89BE3A472DA81E693F45CD7C716DE3392263876FC0F5ADCD3FC713BC180D21E7A06AE1AB93A93B9F298AA7273B23DBFE217C63DD049B64CFE5FE35E23E28F8AF24B3B286EF8CD67EB7AB5C5F0932EEC08EBEB5C7DDE9CF24BB9B7707A5776172F8D35A9B50C249C753A983C48B3CBBB772DC9A996F50C61B9AE62CAC1E49571BBA574163A449B3E6DCDEC6BBBD9A4CC71197A68B497BBE3DABBB144BFEAF9FAD0B64D6C84ED3F2D6A681E10D53C642ED34DB392F26B1B57BB9628C83208931BDD57219C283B9B68255433630A48729452BB386396DDDA3AB31CAB0352416ED74EABB5BDCD7A7FECF3FB217C44FDA73C409A6F817C1BE24F175C060256D3AC249A183201FDECE079510E4732328E40EA457D93E10FF008375FE3C43A75ADE7882DFC0FE1A5994B490EA3E218A378002786F2FCC5C95F9BE5623919C1FBB7CD6577B773D2C0E438BC47F0E0DFA23E05D03C1D36AD388D2DE4CFF00788E2BD2BC19F010CAC924D6CE5B3C915F6C7867FE08F5F12BC19AA69D6EFA4E87A97DB99504D63AF59CF0C196655677F3061484DDC03C30E8D951DDEB9FB01F8DBE15CB0C3ADF8635384CC0B4725BC3F6A848DC00F9E2CA8C93C67A8F4AF4F0387A755FC49FA347D353E1D9D0D6A5369F9A67CA7E01F8570E9CD1FF00A1FD0B751F5AF79F871E09B7063FF455E98AEAB51F811A9784EE3C9BCD26FA19940251ED9C120F43D3A1C71EB8AD8F07786EE92EA78E1B599A4B48DA699046774080804B0EA002475F5AFABC3E169C15D58E88E1F97DDB1D2F877C096B0C1D075F4DD5B2DE1F8E03855F9474C0A7E84B2469878E48D800D8652AC41EF8EB5BEB6995566538C7A715D4E5666DECBB239597428E47E43515A9A94DF679F6F97BB8CF4A297B4467EC647E78FC55F85B26B50C8AB1856EF83D3AD788F897E1B5CE8D2636AE09F979AFB26F27B7BEB76DD22B2F502BCC3E2969B6FB18AB7626BF06C262249A3C79E6D393B1F2EEAD61E4A3290320E0D79DF88A17F31B68071CD7B5F8C60891A6FF007ABCC3C4162B2C8715F5587D55D9A5094EAB38489594FF003F6ADBD267C0C1E39A8EE34F3D00FA53A2B07B71C8E3AD74D9B3D1965775CC6B247E6B6D3D3A529D11360C0DDBBD7BD665ADD4BE67DD35A96133348B9534A5A6E79D530F3A6FDED8D2D23428D0FDC15D0D8F877CF6DAA833D78AA1A48333A80BDABD07C0FE179B5496DADEDE09AE2E2EA5586186142F24D2310AA8AA064B1240007735E7D494DBD0E3F6739BD0AFF0F3E05EB1F163C6FA4F86FC3DA6DD6B1AF6B938B6B2B1B58BCC9AE2427A01D0000EE2CC400B924A804D7EB17ECCBFF04BBF84FF00F04E3F0BF877E217C475B8F891F14A6BB59B47D3B4FB968B4CD2245936ABFC854CCCA46D2642C8CEC55233B7CCAEE7F606FD847C39FB086936771E32D6DED3E2E78C2CA279E2B6B5FB47F61DAB1DED610B6D28667236CEE49076A2202A4993A7FDB2B4787F6B8B5BEB5D16E219A3D26FCE89A4C4904C6D6E35536D24AF396501264B68A09A38E3DC15E585D8FCADF37859863AB469D4A58469D5D95ECECED77A6BAA5DD6ED7A3FDD3C3AF0F6854C451C56714E5EC9FBCF46AD1BDA2EFA2B49EADA97BB18B6DAB36BB9D0BF6A8B3D0BE196B1E17F86363A4E937FA1A34E961A5E9D05AD868D067A49222FD8ED24E7EE36F9199B6A873B73F337FC3657876EFE2D585CCD77E34F183B5BC573A76B1FD99FB8D6A494ED65B582EE4F9E3462713A858F193C0C01F17F8DBE2178D3E0CD97837459BC49A478B743F02CDA6EA569E1DD4F4692DF4F87509CC9732473DBC4C88EC194A969B1330DA10050CA2DFC22FF0082DBEBFF00B3AF86BE2C789BC6DA6DEEB9F13FC4D2C5FF0008F7892EEDA24164C1E4DF0B471B155863DC1E3DA01E154AAF0F5F215AB6331F28394BDE85BCF5D5DE31BA4DB765795BA3BC55D1FD119B703E3385F0D2C43C23F615536A514AC97BBA4E714E518A8DE56E5495DC7DFB5D7EAE6B7FB4569169F163C2FE01F0CF893C3FE22F1E788AD1B5596CEF16D667B4B642A089112368E362CC8AA7CCE4AB74AEFBF68CFDA8B51FD94F47D06FB50BDD1669752B9B7B4B8D3640905C5BAC80879542F0551F6AE18104B019CE33F86FF0EBE3AEB5FB4FFEC19A4F86FE1719354F885E3FD7EEAEBE2DEB1A859ADA6259AECC1A74627908F362113805918C7064E56369771FB03F67CFF82CCFC50FD98F46F0AE87F13BC25E1DF1FF008574DD264D3AE2F61D4E26F12A9B5DA934AE6490C726F006D89C2991810242C0A8FA0A19955A15274B1551D393B24EF74AD6FB37BEAEF66DDDF549248F8BCB7C3FCD73AA2B179761155A504DB4DC612A97BB4A3CD66EC97D956566B9AF7BFE8478C3F696D7BC3B6336A1259AEA0A61172915BA21731A2876081FEFBF97F3AC6D8DE0928DD3337863F69187C7563A6EA5A5D8F87516F1448D746D3FD7C2DCFCBF2960C0FDE523208AE1FC17FB737C13FDA7BE0F5BF897C2F77369FA5EAD7B6FA1C5A95DE95258DBE9B7F6E03416533E3CB8A4513AA8C1D8CB2E031032307C63F102EBE1578DF4DD3B569D99754BF7B2115EA0631DC3234A04521CBB6E55621413F2E31DC1FAC863924EF55492B6DE6F4F35A6BDBEE67E775F259C2A7B0AB8770A89BD2574D35A3567BD9E9DD3DF747BAF8A3C2FA7FC57D3E6935CB2D1F56856568ACF52824559238F3F74BE410CBFDD639F415E53F18FE04E83E105B79B40D526D4236189A09D8092227A11C72BD7AF3EF5C743F167C4D797C34FFB2FD8619A216F233486431DDA4A5B633B0C98A54DBB58E7A11C1E29B6115D5DDCB5E4D7D2910CA77ACE36B6C94960AC00F94A36543775E0E2BA21C413A768D24DAEB7D17E3FD7CF4395F0AC6A273AD251F4D5F97F5FA6A72FAD68B6F04EBFBBF9B907DA8AD736F6DE2EBCBA166E12E34F99AD6F2DE7FDD4B0480F707A8239046411457D4D2CCA8CE0A6A6B5F33E36B65789A7374DC1E9E4ECFCFE67E3C787BF68769ADFE6909E3B9FFEB555F18FC5F5D5A1DBBB6951EBD6BE79D0358B8083F78DF81AD8B8D5A4913E691B8AF8C865708BB9F9BE1B2F6E5AA363C51E23174EFD8B1E9EB5CA9904CF96E98EB44B334A4FCCCDEF566C74DF31C2D7A108F2AB1F6181C1D38455C8AD7465BA6CEDE3F95581E18F3CFF00B238E95D168FA4791FC21BEB5AC3429271BA38772F7DBD335B47447656C45382B238593C30B13642EE15734FF0B7989CA71FCABBCD13E19EA3AF5CAA416AC55BA7CB9AF50F057ECBD7CAC925DDBECC1CF4E4FD454F2B9E87875AF5A5EEA3CAFC09F0BAEB569D5638B6A9E77115FA0FFF000478FD972D6E7F68A8FC59A8D8C9771780ECCEAB6D0EDF30497CF22C16B95C7251DDE5038E6DF3D8D79C7C3CF819FD9BB7F70BF28CF319F4AFD0CF80BE01B6FD9A3F6799BCC2F6FAC6A1AAA1D5A64951249596CA5716AA5D930238E7058EEC82EEDCE315866928E07092AD2F8ADA5BF3D7B5D7CDA3E8B85F2378CCC69516B777D7ADB5B7CEC60FFC140BC7DAE6A7FB62FC37F06F87E5C5D5B59C52DD5C1B9F261B6176C7CEB9793F87CBB4B42E0F501588E40AF3DFDADFE20D8FC114B7B1D274D8EDE1D16286FE7B03E58BD99E3B95BEDA206F3A483C8861D53FD382B2451CBB6212B329167C4FE2EB8F897FB674DAB59DF697A49F2F509EDAF6E5A29161B5B08E0D3410B232C4DC35EB0595955C311BE32C1D69EBDFB2BF86FE24EA7A878FFC5BAC476BA5CC5754BDB790DADB6976E3ECD23C12CA916219678FCFBA22477624B3676C6A16BF2CFED4587857C54EEE55AAF2412B3938A492E54DEAEC9CA4F4B457349A8C5B5FDB196E2B28CA6965F1CC25EED2A515ECE09CA752B4A4E4D5AE9349F35B5F76D27A68CF89BC79E0AB8F89A9B6D1ACADECAD5458596AC2DA616064B5BDB95F2CDAC424788341287FF48467017271E7A93E33E21FD83F52F19FED1563F0E34DBE9359D3F588A79EE67B7B405BFB3E1B73732DDC6ACFB1A39600CD0E5F2CC3636D742A3EECFDA77C71E00F08F85B45F06CD69A85DCBE1CB2D574C121BD168D65F6189A3B7F35155238D6692370004CC87E550E5C11F9F3ABFC53F891F0E3C5BA96B3F0F3C65796B36AD0796E970D0ADC05DEB2C90C53852628DA40AE541552402490A49E5C0FD616325EDF96118ED6777F376B2DD757CAD59B67D5E6D9BF8938FAD3CC2585A5FD951E751A506E55E71778F3C9494237F754BD9C1A5ABDEF16BEBAF8C3E32F0CFECC3E045F07FC3D91AD74D874B78EDA3865822682169FC989D95912591C05BA9794258DF990AA1851DFE51F8B3F1A1B5DD6350985D5D5D5D5EDCACAE5EE7CC870B1F97180AD1A8F9570A98002AFCAAA074F39F137C6BF165F7811754934D92DF43BC9E46FB4C70286B79E07781848CA37A32B2953BB20F0DF331CD70B65E3B8AFE395A6BDDCD0FC91E77303EE31E9D79FCC57656CAEBD4A8EA565D76FEBF1D4FD2F21E3AE1FC360D50CA66A52D539BB27D3DD7E6AC95AF6D36D9BFD1AFF0082197ED4FA1F833E2E7893E0E7C446B59FE1FF00C6A586D62FB6CC3CBB4D5E3622DDB04E17CDDDE56FC6448B6C72368AFD2AF15689FF000AD7C3975A2F8A2F975193C3D29B8D3AEEEC6D6BFD2CC990858F3E75B164008390AB2F40303F9BFF001078E964D1D23B2919678581464932656C70571C8218938EE4D7F479F10AF57E367ECF9E13F1D58EA124CDAB691A7F8962824947EEDA5B28A69A21B9781B65491D4F436F21E0B115EB53A9569619546B5868BCD3D6CFBEB7B7AB5B5CFE6AF1430B83A99EC3154A5FEF0AF2F29C6C9493E8E51B297A5F7D5797E9FF0014F5CD2FE2578BFC32B62FA95EC36F17883C393B42DE46AD64E4192D779F95A44916750B9CA896324608CFA0DB6BA905AC77B2ADDA1F25A58E0962FDF79270B2DBCEAD82BE5B38E4E48008ED9AE0751D0B5DB49BC077D0B359DAE87AA5E417D62876C11A491CE892151D5508455F69056EE8DA0C3E02F04797793DD5D4160B7487CF91A496E2DA674DCECE7259977005BBB64F43511CD2B26D534D69A37D16FDAFA6ABFEDD5F3F829E5345A4EA493E9A757F7F5D1FCDFCA2F1F586B1AF5E2C7A65F43A62D94B2467CF851E6950ED29B9BBE1781E9453BC5FE1DD5BC777ED1693716026D35F6CAEED2012C52223C2C303D0B03FEED15C556588E777727FF6F5BF0F2D8D29D3C3A8A5EEAFFB76FF008F9EE7E107833C28B776A1987CBD7F1AD8D57C19FB8668F6E14715A9E0B823FB22AE307D066BB2D0BC177DE2ED521D334AD3EF354D52EB220B2B4B77B8B8988ECB1A02CC783C01D8D7EC1EE72EA7F38FD5946D65A9E276FA248978D18539CE7DABB7F0778024BC2AC633B7B0E6BEC3F805FF000468F1E7C41D5A4BEF1C5ED87C37D12D0C32DFB5E466EEFED60952468E56B7849D887CA605A465DBD48C57ACF883F61CF83DF0B740B74FF84BFC6971AC7EE1658E3B182E7FD6CCD0C532C110F3445248A506E209C1233915E156CCB0D465FBD95B7FC373EBF29E01E20CD15B0741BDB47A3D76FBF4DFBAEE8F8CFC25F08DA7F9BC96EDF8D7ACF813F67D6D765456876AE3F88E2BDD3C1DF03FC3DA66AB25A43AA35E25BCA22926B8B09ECDADDC93849838C42783F7D80E2BDE3C09FB3FC3A5491B35BB48CD808AA436ECF4C71CFE15ECD1A946AD35528B4D7747CC54C971147112C362A2E338BB38B5AEBB7DFD1AD1F43C87E13FECC563A6C0B8B1504753E5F5E457AFE9DF01ECE3D367B86B358EDED6079E591B85444196FF00F575AF45F8CBA3AFC07F87DA86B0F269F1C5A4593DCDC79D3F97BD9902A81211E5FC8F2C6E464310BDF38AF8274DFDB6BC4BABF8CB529B51F8870DAE9F7128912C6CF6DD2C78602188FEE82025B0086CE4E49E057879966DF5652A7412752CF9537657B697EB6BEF6D7B1FBFF04F80799F10E0258CC3D684147A35296BBF2FBA9EB6D5E96B75DCFB57C0FF000DF458754B77B7FB3DC5C5BDAA6AC2D172AF3401B0A7691D19F03F0AF66B3F86F6FF00103E00C7A3EA0AD717D7971AA6A2589F99E592192D738F6678DBFE024F6AFCC6FD9BBE377C49D5FF006A8D2F56D42EECAE349D5B28D77E5E60DB1A16306149003847C1E81978ED5FA71E35F0DC5E3CF849657125D18F4265BC5BFB650D136A96B2C51B2DB9BA0545ADBBC8FB679704AC4EC372062478384CF2AE6D83AEF1D4D465071564EEB92F7BEBDDAD57F755B73E4F11C219BF0C710FF67E3A3C95536E0D34D496AA324D747F7AD9EA7C47FB2E6A1E28B6D0BC59E2486D61935DB0D22DFC21A22C4FB99AEEF279638648E589C05DD74D0B33FCC3049032A08DAFDBEBE3C8F81FE159B45B1D5AE35ABFD37486B1BAFB2E9E8556EE716624BA9EEA1407F791B3B08E29A2647788112001833C49FB57699E09FDAD7E1AF87619B4FF0007780D35B86C67B48E21A7DBCB602FF108997F76B1DADBAE5E094AE67552CCAAA76AFC7DFF000572F8BDA2789FF683D72DFC3DAA6ADAC2E83752E94FE699D16CA58598BC302480A8C33104AE72C09DC779AF85C2D6787A14E972A94D39454ED7694ACDF9C54AC93BE8F957748FEB7E17C8292CFB095F8829C61CD0A956368EE9351E44E57D74E66A32BFBEAFAC5C57887C71FDA264D57C4BAB1CCAF7175AC5E6A62E64659199E731AEF6DA047B82A11951927249DA100E3FC01E25FB46A6D32F98CB6A51F6EC323264E2260A010CC198939C03823BE2BCCB599EEB50B956621BCDC3B30E7903A37BF15B9E1F97FB2EDD24DFF33445164DFB4C0FD00C8E7EEE460FF7ABD59514A93E67ABDCFD5679F54C45670A51B538EDDADBAB7FC0D3E76673F07ED19E24F01FC4CF15D9F86AE2DEDA16D564BB58EFADC168E428AAF8DC4E15880704904007B9070BE21F8535CF88915BDD69FA5D85B6B96A196EADF4E823852E031DC08545552CBF37014646000702B8CF899A96B1E33F8CFAC4DA3F98D0B3C7179F1DBAA9DCB1AA11CE704B0248CF527BD1A85EF8C3C21636F79249730C76E81D4C4DB4ED1FDF380587BF4F5AFAF861A5154A54E51526968F77EEAD1F7FCCFE14CDB2AC6CB3AC6E3F0919AA4AAD4BCE29A8B8A9CB556D2DD7B5B52E687A4EAFA6DCC735F4ACA61248785F6B46C0300C3A658310467182A2BF77BFE09C7FB42EADFB437FC1283C17AADDC934FAF7C38D42EB48D42E0458FB60B694385C0EA24B1BD86327804DAC99EAB5F86FFF000900BB5D1EFB50BCB19E2D4BCD6B8DD93E410A0E49FE36C36E0A3EF1C0EF5FAB1FF0461F88DA8F84FF0062BD2EDF4F689ADF56D5F5092F212BFBA9B709ADF7F18C15550723FB9D3D38B32AD3FAABF6A92BBB68B6777F95BF53EAB1B0C0578D3AB819B9B8BBDE4DEABAAD7FAD0FB134DF887AE1F13FC33D42185AEBC27ADE993DAEB370898533C82036EF807218F9720C63003679D95A8FAF47E1FF000A69B65AA411ADE5BA6A765F678DCDC42F06CDA911B8046E2AA22000C1F9989C62B057E158B6D73C117967349F65F0EE9777A7436193E54AE3C870E50705C794E33E923629BE27D4AD749874B59B326BBA7AEAAF242193ECE1625D9292C3FE9B1555C7500F3D2BE3A58CAEE165BA4B57DFDD6EDF9DBBA6554C2E1F9EEDF57A7FE0497F97A58EB2D2D752B2B2B485DDA1916D612B924AB26C18DA4F51BB7FF89A2B83D7BC7D3437D690DAC5AA6A5F65D3ADE06DAC1BCB0BBCF0BD54125873DD5A8ACD4E8754DF9DD98C9493B36979591F0FF857F603B5F0A7866CD7C5DE206D2FC4F70B2DC1D26DCC771E5428E5433C89B963DC0646F2A46186D3C67EA8F843FB4D7C27F85DE15B8F06FC3E82D7E18EBFA0DABDCEA97D7D3453DF6A73C51EF8C19E7787CC864FB3CAAF129553E6EC030E01F92FE337ED91AE784F4A99ECFC5D7536B9AF5CDCCB7F358DDB7D9E3B67BB925F2882CDFBD976C6DF2EC31C3B11B71925069FC3EFF8298DCCBE31D3759F1669B1F8BAFB45D660D734F97568FED115ADCC32A3C2620A4340ABB0642B483190147047B588FED1AD8A9627EB8FD8BB7B968A492D74925CCEF6D9B576FE2D2C7DF61FC01FEC3CCA19A60AB2AF1829A746514E529453B38CDC525AECA49DD2BBD19F7678CBC55169F79E1DD275E8658747F12437FA0D96A12C0F62BA7D9DC5F4448B87BB12662685AE262B36F48A1BCDEFB0F9700F193FB4EF8013C49A76AFAF6BD75A569B75A8DD7D8A6B9B791AE9A5F29669F5AF2416686699E582081F98FC9B571FBB22BE61BAFF0082B7EABE39F8BB77E28F889FDA76B71A74924A2DB4F8079115B33A3456F66094DB196F2F748EDBC9193CF347C26FD88FE337FC14A6D755F8A5E158749F0EF81752D4DB4BB5D4F5ED78CCC5D40416E8AA1EE257DBB576AC586CED5E00033E6C5623152A34E8C942366A524ACD6892D24EFA2D2DA25A5D5927C3C17C7947194730C1F1561A7818C54A0A6A71E6739F329452946FCF6774E29A766A51E66DBEFB4AFDB47C0FE0CF196A175E1BBBF1E6B725D593E9E0D86976F6AF243F79D59A6970D950403B7209CA819C57EB17EC677FE11D4BE17693E2AF0EC7676BE13B7B2436314B955B2668CB859779255D5830624E41CE2BF37FC41FF0467F09FC1E821D42F3E285E68767E782BA86ABF648E3918AE4B2C681B0FC93E53C8CF847040C66BCAFE20FC2BF1F7EC73F059749D1BE2D5AF8A7C3BE1D7F3ED16CA24B7D7346B979C96296FE6399A16D9287C9431B202010091F4D83CE31342ACE38851775A25A3BBD5EBB6B65A6EFA5CFCCF1DC1B924274711944310B09152E79CA9CA4A36B59B568B51D5B9349B8A6A4E2F63F493E2AFC5CFF0085B7E21F1B788349F8ADE19F09FC3BF00A5B9F10BA5AC57CD3DFCEB2F95E74D703CB3E62BC076A82F858D0B7DDC71FF07BE18782FC57F0EFC3FF0016BE2F691E19D5B509E08F51D1EC974C5B436417CC669268106D99989465594F0DE661B80C7E27FD83BC5307ED69FB1CF8C3E1BF8565B8B1F1278C3E2069CFAAE95AA5C5B9B4F3262EB15DC01615014881126DE0B06442A41600FDF51FECEB65FB3F7C2BD6FF00E11BBAB3F1978B67D191B4FD6B5A8BCED174F9D1196E7C9186CCA63C8210303950CC84835E0E6B8CC6CEA2A518D9DB9A5AB7ABE918F5B2F449B5276475702E3A39BBFAFD5ABEC1C5AA54E14E318C9C745273AC929ED2D65372BA525183D147E41F8AFF00F055BBEBEBDB7B4D2740F0F496BA5CC64B764D3EDADADA127398E38951FE520FDEC8627757D5FF000AFF0068FBCFDAD7E1A68FAA69BA6DD5AB5EDB1B75D334FB49755B28EF1A636ECBA84580B2D8CCB1A4651519C2C8CC07C9E62FC89F14BF6128FC59E3B8F43D3752F0BDBF85ACAF1A2B0D50C85EEAE25203BD9620510894B79C55017746DA8EE170C35BF688F052FF00C1333F676F87BAB5C6B53F8FBE1FCDE29D5F4A9355B62237B41730C73E9F76BC3797388FED91EF05FCB2C5D0EE5551E1E5B87CC214E4A5294A29C7993776ED7575ADEEAEDE9A7CEC7F4B71D4B80E1FD9F84CBA11A58BA8E56934DDA2E2DB53BDA1EF494746D34DCBA735F93F8F7A70F1FF00C5A8EDF54D4FFB556689AF6EAFB512A926BD68A2531DFB5C9557D938712402558AD608CC1197915091E4BFB65F89BC59F1A3C3DE1FD4FC52D6D25DC961134925C46219EECA79F107900C6D62B6E461D5198825164501CFA6F8BFFE0A06BAE785BED11C1A1DE4D2EA2FE207BD8F24DF6AC9B671AA34796692492793989985BAA5B22A46A0E2BE40F8CFF142CA079A2B5B89AE19A475885CDD79B2050CFC16E03139249007CC723158D6A31AF523EC5B6EF7ED67A7DF6D7AADFD4FD9B2FC3470D828E2338A5082A31B42FCB26D34D3E5B59C79BDDBE8F48AF23C8BC57E37D2F403892E23DCBC8F9C563F87FC47AA7C5512D9E8D16DB18DF6CF720670CC3E54423F888C9F6C0FEF0AE77C6DE199AFBC2575E25BBBAD144325DB695169B737CB16A53CAD6EEE2E16D73E698233B0F9A408CBB2A82D870BF6BFC20FD9CFC31F09BFE09E7F0BFC596BAEADE6B5E3469B52BAD3E2B75FF4720C88C5CEE2C193F72019400E246D80AC4C5FECB1587A581C1FD61EB3BA5AECBCFF0045E6D1FCF7C3FC4589E27E28FEC38D454A85A5F027CD26B685D5F953DE4DD9593574ECD7CF7E1DF85ABA05BFEEA2656C09033C218CAC5D9777E255B38CF200C92715D2D969BA4EA160D67346D3C732EC7CE3E739EA576E3183D09383938351789EF4473B5B6D8576BE198862C381C0F9BA118EA7A7A7418906A724126519BCC0C00F98E40078550700E467AF7E4726B863888D58F34B77D7FAEA7E9DFD9F86CB6F86A505CB156B5B4F4B75F34FF53CCBE2A7C28B5F0BCF6D736F25D59E96D71868E3C37D9CB6DC48A0E32A76F0380415C1AFD39FF8260E8BA87807F669F06E97A9CECF7175A8CB2CDB8FEF1629C4F2C6AE3276BEC95188C9C648CF15F0C6ADA5D8F8EAE74FD2CC1BED4DD8BA9F0709842199768E376E0A1883F36E51D738FD0CFD91A5B81F0DD3597DB0A68FA9DC4F0CD33050D3C50BC7C9F4F35D89F40A3D466737CCA6F0B1A527ADFAEFE5F85FF03F9EB8938770B82CEAA55C225184A09F2AF854AEEF65D13B474E9776D2C7D1FA57C50D6346B5F0549A95D5D5A6A727F6F5C5D9B590B0B59930A926E232595DB08480704F15C6781B49D5BC47E0AF09F83F43B3D435CD49B418B4BB592DE3691E79E48D50C8D2ED2146E8D5D9D8E001935E07E3AFDB4ADFC4DF129D5646D4F4BFB37D9A39EC8EC8481B85D48B273F3176655001E7E7C9C0AFBF3E007EDF9E1DD47C3561A4E8FA7B68767A722DBDB5B861B62455DA003FC59F5EF5C79664B2C6BE5AD2E48AB7ABD17E88F82CDF3AFA9C6F87873C9EEFA2DFEFD5EC7D59FB30FECC1A3FC0DF867616B3E976ADE20BCB483FB5E7948BA324C8A576ABB754525B180064B1E7392579DDAFED1B777702BC7A9B382395FB485F2FD8FF003FC68AFD328606852A6A9538AB256E87E4B5F1989AD52556A49DDBBBDCFE6875AD664964CC9334AC5B0371CE4924E7F327AFAD6F7C0FD0D7E277C66F07F8466BF5D357C53ADD8E90D724075B61717090EF2B91C2EFC9191900F23AD53D0BE16EB5F13BE2D697E09F0B58CDAD78BF5CBBFB1D869D6CE0CD24BC9E7A055550CCCC4855546624006BF6CBC33F0B3E1BFC38F809E01F837AB780BC0FE2EF1B785B4DB3D3F506B1D22D9D5F50845B17BD7F2D4DD2A3194486E182152A59D9010D5F0B428C250F6B59B51E9A3D5F65EA7F71717715E6380C47D4B2BA5ED6B352BDA697B356F8E4DA7B37B791F9DFFF00051EFD8BBC5DFB58FEDC5A05D7C2ED061BED43C55147E1F36C9018ED748874F8E4B54967653B238122B4453BF0088E30BCB28AFD0068BC07FB2AFC1AD37C1BF0EEE2CEC64F06DCBD98519997486596CDEF2F2F66CBA35BCACF048EECA9719B829137CACB6D43E2BFED0FF0F3E0978EAEB50D1EF99750D5A09EC2FEDF43D45265B596664919A4F25260C3CEF2E4204B97651851B48AF9FBE1F7C7DBFF0089DF0B2E343BEB79AE2F2CEF1AFEFB52874C33C17B3235B2C5A8491AB29957C986389629940491653B260E157CAC3E655AAE17D8632DED22DD9DD59ABAB34EEAD2D6CAFB5AF6EA7E23C37C319DE438DC36639D61E5F5095B9EAB52972A51695F954AD14B7728DE515672E5B9E6BF183F689D5AFE0BBB29A5F1035D3451C1B3529D51FC9085A395D8E6432B4D73348D182A0A880B29F2C6DF08B7F8C53685A9CD247318FCCDC2E124C3098E46EF333DF3921BA83C820D773FB5AF85EFAD3C59757D6F3D8E75105E2105F25DBDC465761959C052642430691953CD27CC58D5781CEFFC13B3E10E93F1B7F69AB8FF0084A27863F0FF0081B4A975DBB8E559C9BD963648EDEDFF0072AD233191D640A14EEF28AF4639CA9E0DD7938C9D9ECEFD3FC8FEDCC4F1561F2ACBA9D7C1D353A752316B957329B696D6BA7F2FD2E7BA7FC1283F65BF13FC25F186B1F1D3E276A5FD8FE13B3D3EEA3F0A6997EB1B5D78862895EE84D3A92D31891ED902A84699D7E60150176F6DFDA3BF6B2BDD7FE274970B693DBC3A7DEEA5A86989247FB8B416DA72992089884290C936C124782C42984EE2D220D9F10FC5AF127ED67E2BD77C1DE0E860D1ACACA0BFBAD67C473C7E5DEDAD845736C92BCD6F6CEF2B4A52D502979656769E4556556568FACF88BE08F04E8D7FE21BAD43494BED52FAE759D1AE7C55ACCE0F9D3358F991CB146F1B2C503A868514AB28CBFCF32C6C5BEAA5CF89D70F656715CCD59CACBBADEDBF6BEB7B9F83F08F0BE57C335ED5A87356ABED1F2269F2292566F649B5A595EA38C52E4B49B3E4586C3C45FB466BD6BA6DAEAD1F86749F0DF87EC9EF6EAE637BA64599C4AAA8B1F9923C92BDC708CE0ED8D81640816BCA7C75E306FD9EF43F89DF0DBE2369325D47E3AB2B7D26D6EAD2E16E6D6CA78754B798DC246848123ADB346AFB43A99D89C0250FD0BF173F696F09E81E1AD734FF000D693A09F0FEB53DB6BF73A759E9FF00D930DCB5AC0B66A924512B32891A59270ACE8146DC1769371F913F6CC827F8C379AAF88747B892FBC49A7BC12DD43BA311EAF2444859630ADB51CA889C460B090A38523E5CF9F43014A9B5793E7DB9AFA59E8B7ECAD67FF00F638FB09C658CA555C68D3FECDE58B5495D578D482E773B3B735EA2E5947DE6E36E44DF333D7BFE09A173E1FB0FD9DB57FF0085B51CB75E07D035ABCD0B48BEBDB37BAD26F320DC4D022AAB6D919CB30CA8DC78562C8CB5F42E9BFB18785BF628FD98668CC5A5DF78DB548B4F87569B54B8B596ECDD8BFB595EDE28CCAB2A5BC812E046A555FCAB5904A5407965FCF4F08FFC143F49FF008437E1AF8134FB7934AF0AE876B3CDAC58C3E5B16BDF93E760DC4996F325C9DA4B98F2576107EC8F84BFB546A5F1D3C3DFD8775AD5C786AFA3D41E6924FB6982532FD9E184332ACE9E5C369676CEA1B7AB4B2CC83F8B29E7E332296071B8AC6AA927EDD47DD6FDD8B8DD5E2ADA5EEEEAF67D3551B7E59E0DE5353158F9E6F4F11274D4E2F91B6E2946D376577BBDDA8B6ADBF2B95B9FFDB3FE1FF873E301B8D4B5F8DA66B8F11DCEA1A99BCD24EFBB7BDDD7525DC61C88DB6A79691C09287221DE78970BF2EF88FE2DD8FC31F0B3697A5C771A9787F4F122E99689D7488CCB248D144652CDE5EF959B19E3711CE001F5DFC67F8516B13DE79762D099218A588C51F9E21CDBB5E4F20DC7F79B239A0B44769184AC8CC067CBC7CBDE24FD95EF23BDD5BED922E9A8D70B15A87982472B0764997736C5F91A39305723E63C9CAE728C54EA3A55FE1DED776BF5F9DBAF63FA871545D0C1D3C7E5294ABF2D94DC61CD18D9C959EDC977AC5E89A5A2B267CFFA97ED0BA6DEDC0C4737A8DC91BFE63A9EBFFD6AB9F0FF00C41A97C5FD5BEC5E1FD3AE2E963004934E7C982207A3316C9CFA6D058F615CB78BBC091F8035A561636EA978CDB2596324061B720803A6082338E08AF59F855E245D3B428ED74211B5D4EDB9EE963071C619A35C8F988E379E71D00EB5F4F88C3E168D352A507AED77A1FCB19971C710C317530B8FAAA338BB34A2AEFD2FA24F7D53FC0F42FD9C3E190D2FC6FACDC6A1A843343A45BACB737254436AB28188A31CEE60642ACD9E4F96DC64115B9F11BF68ABAF8A9E00B5F87BE178D749F0DDAA7EF6592731DE6AA03172EF9C6C8D9CE42753819E0573B2DC5D788ECEC6C6DA31069B11779E304A34D29529217008E1632C14F20798DDC935A9E14F8651C97CF2436CAB300AC8C235DCBC10B95181F7549EB5E3470EA757EB15775B2EDE7EA7C66619956C42F669DD3F89F597FC046A7C2AF8687C3D3471F92D6B25BAE72A37478C0DC71D07007B6715F4B7C39BD6D26C23FDEC2B25C32948E4076A8032063AF0A7A0AF37F06585CE9522ADEB5BCD670B1666742B32461884F90FDE05B9C7B1C138AF58F0826937906E6917ECAEC88F283B83FCC59C91D471F2E074DA79E2BD4A2D296878F5A9BE53D06DFE24EB3689E4DB491B45181804191864679CF23D71DA8ACEB6D3135085668AE3CB6906E911019829EC370033C63B7B76A2BD98D5A895933C09616937767DD9E20FF82707C3AF83BF16358F8A1E0FF0EAE87E28BEB19E1B99B4E11B792D2C892B4D6914D195866650230B90A55A4213CC28D5F2CF8EFC6BA77ECD7E198EF24D5345D2F56D43515BFF002F4B821B3DBF39B4277AC0E4C76F710A0690ABF9D15D4D9F39822AFE83FED0B6E89F0C6FB508A385A6D36DE4BB2B2C60F9A87AC7BC61972CA18B0E72A318E08FCA8FF82927ED1F61F11204B7D27438F4B3A2CE65926E11A66920B7390138E15540CE48200C954455F8DE20CCA8E02718C23AE892FF0014ACDAB6CD59DEEF5DBD7F71F05615B33C4C3078ABCE9CE5693D2E9453695E576D3BAD93B74D755F34FED0DF1D6DFC6B3D8C71F367636D1A444AE5B6155729E63AF98C55DE65DDF2A10230B1A2A28AF33D03E25DF7853517BEB1BDB8B2BA61B12489FE6518C720F078C72738F4EF583AFEA4248A56DBFBB65C81DC6493FA6315C66B5E22613B3619557938EB8AF270AF9D371DFF002FEBF13FB1338C560F0F86797CE0A541AB38C973295EE9F326ACEF7D6EACCEDFC61F1FB52B69EF34ED62F7507B37B3FB4D9DD4936D854905658D942ED2CCABF7B2A7800E78C793FC2DFDA2759F00FC42D5354D1EF26B5B5D4ADCDA3C6547FA543DF1E8DBB760F3D7E95F637EC9FF0008BE0FF8E3C1DA4EA9E33F08EA9E22D6A24959A64BF36AB0B348BE498F04FF00AB00E411F3191BA601AF67D23F60AF825737925EAF86F56B3D1AC4309162B8864BD01370765768F6139180A53A0049078AFA1C3D1A74E9B9CE1CD292B3BBFC7E7A1FCABC41C695DE36782C15474F0F46ACA549462A3C8ADF02B34B953E66972AD2493DACBA3F835FB5CF82FF00641FD887C3B65E0582E35AF881E36D2A1D6BC45A94F603CBB7B8BC50F67E5DC1FDE86B55466408A0333862C5B207C8DF12BF6B6D5B589AE3ED08970F24922C72CAEF72F6E92402DDE3512315DA13A103706F98329E6BECCFDA5BFE0993A0E99FB266B3E30F03F882E0C7F0FEC8B3D96AB622106DF7BC92A44F1C8E7396908DE0825CE360231F96579E2BFB65DC91795B5D4EF6607AFCD8F5AF3AACF152ABECDDA308AD12E9E7DEFF00AEA7EC9C1B9FE492CA3FB4B072954C5569355AA544DC9D4497BBB25CA935CBBA50B42FA1D36ADF112FB59BCC5E4D248D2C7F6566F37E6600600C9C80A06074E8315B361AF325A47BB6CDB9229D959D94EE0C15C3338253EE96C2E142BE782315E7577A94B693B286CA96DC148CA7FDF3D0FE54D8FC69269D6E6E246925D9B6521B93CA96E39EBC1FC4D7653955F66A317A337AD9F47DA3A95A4F63E99F047FC168B59FD9912EBC17AB7817E1CF8DFC3B611C50E9567E20F0C58CCAF13A1251A48A18E660CE5998B172DBC9E0922BE56F88DFB506B3A87C5A5F1CDD5E413CBAC5DC9730214487C948D808E11128DA90C51ED863540A8B1C488AA8AA10792DAF8DEFFC6BE2693582F1C3F32A478897CC08301431C12DC0E4679AFB8BC2FF00B1CF84FE34F81B49D4EEAD22B3BBD5AD22795A240C88ED1E58852338DDD06E070073C9AFA6C4D3852A50A75E3CDA59FF004FFCCFE1CCAF39961B897199864551D3529CA5156D395CAEBAE9D34B2E9D8E1D7FE0A1363AEF86D19AF48BEF24A4A6E2E6466F35A68E433A8DFB436E5C038E0638246471BE26FDB03FE12C992184411DADBA1891208B01C1FBDB88FF0059B8853F3640238DB5E81E27FF00825568BA7D85BDF43A9ADBC77007CA10C85013B7F8BA93FA7BD43A5FEC127C31E2992C5752B268448C153CB243AC7B480D904700F031D58939E0578F4F079641DE9F35FCFA7E67ED989F1838AB174A34AB2A6ADBB8A6AFE7D2CFD34B68792DE5FDC7C5E974EB29377F67594A23477DA1C10A55B18FBD851FC59392062BD63E157C1D5B7F29ED19AE155FCA312AF98CCDB498D703A9E4BE4678C739E2BD2349FD9063D1FEC7186B375990ED8FCD618442AC137142406662CC7079FC8FBB7C12FD9B6D6196D6137624BAF345BC73BA1760ADE5BBE493CF1C0E38C75391B6B1151BB286DE67C1E3317531B5E78BC659CDDB65A68AC91E53E1CF859710CAA258FCC8D70AD21385910FF17A00EFD49E839EA0D7A07877E13CED136600F3492956DA857E6DB9718EBC0E00EE1BBE403EFDA578186936C2E15E39AF214FB4334AA0AB99165D83A71B76124F766271D31345A25B5A789AFAC63332CD6AAB17980A6F2410D27CDB704EF2C558A648DB919049CA31DAE7973928EA8F25B1F00C9730C7752473F925F740CE854A8E9147BD4E50805895385CE47406BBAD03C03F66F31A38555327610A4CAA141F37190339E47AE14FA1AEEBC236167E25BD9AFAD6D2087CF0C195902386857E43BC67200E00C0DA31D79057FE110B6D1ECCDBA6EFB2A5E2E8C810ECDBF2A6F217F8410E98DA46318FE1523A631B6A724A77958E757C132453CBF668E49198ABC881FC830E5176A95C8FE1C73EB9FA92B7A6F888BE1E8218E2876C73AF9CA889B550127000DDFDDC7E39C71800AE8F6CA3A1E74A8C9BBD91FFD9),
 (2,'Manzanas','5.00',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),
 (3,'Bananas','7.00',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);
/*!40000 ALTER TABLE `product` ENABLE KEYS */;


--
-- Definition of table `producto`
--

DROP TABLE IF EXISTS `producto`;
CREATE TABLE `producto` (
  `idproducto` int(11) NOT NULL AUTO_INCREMENT,
  `Nombre` varchar(50) NOT NULL,
  `Precio` decimal(12,2) NOT NULL,
  `Existencias` decimal(12,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`idproducto`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `producto`
--

/*!40000 ALTER TABLE `producto` DISABLE KEYS */;
INSERT INTO `producto` (`idproducto`,`Nombre`,`Precio`,`Existencias`) VALUES 
 (1,'Artículo 1','5.21','10.00'),
 (2,'Artículo 2','1.25','5.00'),
 (3,'Artículo 3','3.00','0.00'),
 (4,'Artículo 4','0.58','0.00'),
 (5,'Artículo 5','1.00','0.00');
/*!40000 ALTER TABLE `producto` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
